/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem;

import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystemResolutionException;
import com.ibm.hwmca.fw.service.managedsystem.config.ManagedSystemConfigData;
import com.ibm.hwmca.fw.service.managedsystem.config.ManagedSystemConfigException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ManagedSystemManager {
    private static final String TRACE_MASKT = "XRVFMSMT";
    private static final String TRACE_MASKF = "XRVFMSMF";
    private static final String TRACE_MASKD = "XRVFMSMD";
    private static List parsedSystems = null;
    private Map referencedSystems = new HashMap();
    private static ManagedSystemManager managedSystemManager = null;

    private ManagedSystemManager() {
    }

    public static synchronized ManagedSystemManager getManager() throws ManagedSystemConfigException {
        if (managedSystemManager == null) {
            if (parsedSystems == null || parsedSystems.isEmpty()) {
                throw new ManagedSystemConfigException("ManagedSystemManager - No managed systems configured?");
            }
            managedSystemManager = new ManagedSystemManager();
        }
        return managedSystemManager;
    }

    public static synchronized void setConfigData(ManagedSystemConfigData configData) throws ManagedSystemConfigException {
        if (parsedSystems == null) {
            parsedSystems = new LinkedList();
        }
        parsedSystems.add(configData);
    }

    public ManagedSystem getManagedSystem(String machineType, String machineModel, String machineSerialNumber) throws ManagedSystemResolutionException {
        if (this.referencedSystems != null && parsedSystems != null) {
            if (!this.referencedSystems.containsKey(machineSerialNumber)) {
                Iterator it = parsedSystems.iterator();
                boolean found = false;
                ManagedSystemConfigData systemData = null;
                while (!found && it.hasNext()) {
                    systemData = (ManagedSystemConfigData)it.next();
                    if (!systemData.getType().toLowerCase().equals(machineType.toLowerCase()) || !systemData.getModel().toLowerCase().equals(machineModel.toLowerCase())) continue;
                    found = true;
                }
                if (!found) {
                    throw new ManagedSystemResolutionException("the ManagedSystem for model[" + machineModel + "]/type[" + machineType + "] is not defined");
                }
                ManagedSystem ms = new ManagedSystem(systemData);
                this.referencedSystems.put(machineSerialNumber, ms);
            }
            return (ManagedSystem)this.referencedSystems.get(machineSerialNumber);
        }
        throw new ManagedSystemResolutionException("ManagedSystemManager.init( File ) was never called, or failed to complete");
    }
}

